/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.rsf.requests;

import com.ibm.hwmca.base.rsf.requests.SdrHttpRequest;
import com.ibm.hwmca.fw.persist.PersistentData;
import com.ibm.hwmca.xfw.rsf.XFrameRsfRequestBody;
import java.util.ArrayList;
import java.util.Iterator;

public class SdrRequestBody
extends XFrameRsfRequestBody {
    public static final String RSF_SDR_RESULT_RESPONSES = "Sdr Responses";
    private ArrayList requestList = null;
    private boolean zSeriesSa;

    public SdrRequestBody() {
        this.zSeriesSa = false;
    }

    public SdrRequestBody(PersistentData data) {
        super(((Persistent)data).parentData);
        this.requestList = ((Persistent)data).requestList;
        this.zSeriesSa = ((Persistent)data).zSeriesSa;
    }

    public PersistentData getPersistentData() {
        Persistent result = new Persistent();
        result.parentData = super.getPersistentData();
        result.requestList = this.requestList;
        result.zSeriesSa = this.zSeriesSa;
        return result;
    }

    public void setStorageRequest(boolean storageRequest) {
        this.requestType = storageRequest ? "ssdr" : null;
    }

    public void setZSeriesRequest(boolean zSeriesRequest) {
        this.zSeriesSa = zSeriesRequest;
        this.requestType = this.zSeriesSa ? "eserv" : null;
    }

    public boolean isZSeriesRequest() {
        return this.zSeriesSa;
    }

    public boolean isValid() {
        if (!super.isValid() || this.requestList == null || this.requestList.isEmpty()) {
            return false;
        }
        Iterator i = this.requestList.iterator();
        while (i.hasNext()) {
            if (i.next() instanceof SdrHttpRequest) continue;
            return false;
        }
        return true;
    }

    public void setRequestList(ArrayList requests) throws IllegalArgumentException {
        if (requests == null) {
            throw new IllegalArgumentException("SdrRequestBody: List of requests to be set is null");
        }
        this.requestList = requests;
    }

    public ArrayList getRequestList() {
        return this.requestList;
    }

    public void addRequest(SdrHttpRequest request) throws IllegalArgumentException {
        if (request == null) {
            throw new IllegalArgumentException("SdrRequestBody: request to be added is null");
        }
        if (this.requestList == null) {
            this.requestList = new ArrayList();
        }
        this.requestList.add(request);
    }

    public String toString() {
        return this.requestList.toString();
    }

    private static class Persistent
    implements PersistentData {
        PersistentData parentData;
        ArrayList requestList;
        boolean zSeriesSa;
        int version = 0;
        private static final long serialVersionUID = 1L;

        private Persistent() {
        }
    }
}

